#!/usr/bin/env python

# Copyright Nicolai Bæk Thomsen
# Author: Nicolai Bæk Thomsen, Dept. Electronic Systems, Aalborg University
# Date: 3/3 2017
# 
################################################################################
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You can obtain a copy of the GNU General Public License from
#   http://www.gnu.org/copyleft/gpl.html or by writing to
#   Free Software Foundation, Inc.,675 Mass Ave, Cambridge, MA 02139, USA.
################################################################################

import os
from speech_navigation.srv import *
from std_msgs.msg import *
import rospy
from subprocess import call
from subprocess import Popen
import contextlib
import wave
import numpy as np


def get_duration(f_name):
    with contextlib.closing(wave.open(f_name,'r')) as f:
        frames = f.getnframes()
        rate = f.getframerate()
        duration = frames / float(rate)
    return duration

def handle_say_text(req):
    f_name = '/home/sociobot/catkin_ws/src/misc/data1/tmp_utter.wav' #Must be set to a correct destinnation
    arg_str = 'espeak -w '+f_name+' \"'+req.command+'\"'
    call(arg_str,shell=True)
    answer_duration = np.ceil(get_duration(f_name))
    call('aplay '+f_name,shell=True)
    rospy.sleep(answer_duration)
    return 0

def say_text():
    rospy.init_node('say_text')
    s = rospy.Service('say_text', SayText, handle_say_text)
    rospy.loginfo("Ready to speak")
    rospy.spin()

if __name__ == "__main__":
    say_text()