#!/usr/bin/env python

# Copyright Nicolai Bæk Thomsen
# Author: Nicolai Bæk Thomsen, Dept. Electronic Systems, Aalborg University
# Date: 3/3 2017
# 
################################################################################
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You can obtain a copy of the GNU General Public License from
#   http://www.gnu.org/copyleft/gpl.html or by writing to
#   Free Software Foundation, Inc.,675 Mass Ave, Cambridge, MA 02139, USA.
################################################################################

import os
from speech_navigation.srv import *
import rospy
from subprocess import call
from subprocess import Popen
import scipy.io.wavfile as sc_wav
import numpy as np


def handle_get_audio_segment_duo(req):
    if not os.path.exists(req.dir_name1):
        os.makedirs(req.dir_name1)
    if not os.path.exists(req.dir_name2):
        os.makedirs(req.dir_name2)
    p1=Popen(shlex.split(req.command1))
    p2=Popen(shlex.split(req.command2))
    rospy.loginfo('Recording Started')
    p1.communicate()
    p2.communicate()
    rospy.loginfo('Recording Stopped')
    fs,X1 = sc_wav.read(req.file_name1) #Get audio from wav file
    fs,X2 = sc_wav.read(req.file_name2) #Get audio from wav file 
    X1 = X1/(2.**15)
    X2 = X2/(2.**15)
    return GetAudioSegmentDuoResponse(np.array(X1[:,0]),np.array(X1[:,1]),np.array(X1[:,2]),np.array(X1[:,3]),np.array(X2[:,0]),np.array(X2[:,1]),np.array(X2[:,2]),np.array(X2[:,3]))

def get_audio_segment_server_duo():
    rospy.init_node('get_audio_segment_server_duo')
    s = rospy.Service('get_audio_segment_duo', GetAudioSegmentDuo, handle_get_audio_segment_duo)
    rospy.loginfo("Ready to record")
    rospy.spin()

if __name__ == "__main__":
    get_audio_segment_server_duo()