#!/usr/bin/env python
import os
from audio_record.srv import *
import rospy
from subprocess import call
from subprocess import Popen
import scipy.io.wavfile as sc_wav
import numpy as np
import shlex


def handle_get_audio_segment_duo_1(req):
    if not os.path.exists(req.dir_name1):
        os.makedirs(req.dir_name1)
    if not os.path.exists(req.dir_name2):
        os.makedirs(req.dir_name2)
    p1=Popen(shlex.split(req.command1))
    p2=Popen(shlex.split(req.command2))
    rospy.loginfo('Recording Started')
    p1.communicate()
    p2.communicate()
    rospy.loginfo('Recording Stopped')
    fs,X1 = sc_wav.read(req.file_name1) #Get audio from wav file
    fs,X2 = sc_wav.read(req.file_name2) #Get audio from wav file 
    X1 = X1/(2.**15)
    return GetAudioSegmentDuo1Response(np.array(X1[:,0]),np.array(X1[:,1]),np.array(X1[:,2]),np.array(X1[:,3]),np.array(X2))

def get_audio_segment_server_duo_1():
    rospy.init_node('get_audio_segment_server_duo')
    s = rospy.Service('get_audio_segment_duo', GetAudioSegmentDuo, handle_get_audio_segment_duo_1)
    rospy.loginfo("Ready to record")
    rospy.spin()

if __name__ == "__main__":
    get_audio_segment_server_duo_1()