import os
import cv2
from facerec.feature import *
from facerec.lbp import *
import numpy as np
import random
from sklearn.neighbors import KNeighborsClassifier
from numpy import linalg as LA
from sklearn.metrics.pairwise import cosine_similarity
from skimage.feature import *
from sklearn import decomposition
#import warnings
#warnings.filterwarnings("ignore", category=DeprecationWarning)


#PCA training, return the learned PCA model and transformed features
def PCATraining(features_A, features_B, training_pool, feature_dimention):
	training_features_A = []
	training_features_B = []
	pca_features_A = []
	pca_features_B = []
	y = []
	for i in range(86):
		#print features_A[i]
		for j in training_pool[i]:
			#print features_A[i][j]
			training_features_A.append(features_A[i][j])
			training_features_B.append(features_B[i][j])
			y.append(i)
	##print len(training_features_A)
	#print training_features_A

	pca_A = decomposition.PCA(n_components=feature_dimention, svd_solver='full')
	pca_A.fit(training_features_A)
	pca_B = decomposition.PCA(n_components=feature_dimention, svd_solver='full')
	pca_B.fit(training_features_B)
	for i in range(len(features_A)):
		pca_features_A.append(pca_A.transform(features_A[i]))
		pca_features_B.append(pca_B.transform(features_B[i]))
	#print pca_A, pca_B, pca_features_A[0][0], pca_features_B[0][0]	
	return pca_A, pca_B, pca_features_A, pca_features_B


# return a list, where the first index is the person id, the second is the pose id
def ReadImages():
	images = [] #used to store the images, the first index is the person id, the second index is the pose id	
	for i in range(86):
		images.append([])
	names_file = open('/home/xd/Data/VisionDatabase/Face/2D/LFW/people.txt', 'r')
	count = 0
	for line in names_file:
		line_splited = line.split()
		if len(line_splited) == 2:
			#if int(line_splited[1]) >= 10:
			if int(line_splited[1]) >= 11 and int(line_splited[1]) <= 20:
				#print line_splited
				random.seed(2017)
				#file_list = random.sample(xrange(int(line_splited[1])), 10)
				#print file_list
				#for i in file_list:
				for i in range(int(line_splited[1])):
					#img = cv2.imread('/home/xd/Data/VisionDatabase/Face/2D/LFW/lfw-deepfunneled/'+line_splited[0]+'/'+line_splited[0]+'_'+str(i+1).zfill(4)+'.jpg', cv2.IMREAD_GRAYSCALE)
					img = cv2.imread('/home/xd/Data/VisionDatabase/Face/2D/LFW/lfw2/'+line_splited[0]+'/'+line_splited[0]+'_'+str(i+1).zfill(4)+'.jpg', cv2.IMREAD_GRAYSCALE)
					#print '/home/xd/Data/VisionDatabase/Face/2D/LFW/lfw-deepfunneled/'+line_splited[0]+'/'+line_splited[0]+'_'+str(i+1).zfill(4)+'.jpg'
					#img_data = img[65:-64, 65:-64]
					#img_data = img[75:-75, 75:-75]
					img_data = img[77:-77, 77:-77]
					images[count].append(img_data)
					if line_splited[0] == 'Pierce_Brosnan':
						cv2.imwrite('./Pierce_Brosnan_'+str(i+1).zfill(4)+'.jpg', img_data)
				count += 1
	print count
	return images

def ExtractFeatureBSelf(feature, feature_name):
	#print np.sum(feature)
	result = []
	step = 0
	if feature_name == 'LPQ':
		step = 256
	elif feature_name == 'SIFT':
		step = 128
	for i in range(0, len(feature), step):
		#print np.sum(feature[i:i+step])
		for j in range(i+step, len(feature), step):
			##print feature[i:i+64]
			##print feature[j:j+64]
			#result.append(np.sum((np.minimum(feature[i:i+step], feature[j:j+step]))))
			#result.append((NormalizedCorrelation(feature[i:i+step],feature[j:j+step])+1.0)/2.0)
			#result.append(cosine_similarity(feature[i:i+step],feature[j:j+step]))

			#print (-LA.norm(feature[i:i+step]-feature[j:j+step])**2)
			#result.append(np.exp(-LA.norm(feature[i:i+step]-feature[j:j+step])))
			#result.append(-np.sum(np.abs(feature[i:i+step]-feature[j:j+step])))

			#used
			#result.append(-LA.norm(feature[i:i+step]-feature[j:j+step]))
			#result.append(-LA.norm(feature[i:i+step]-feature[j:j+step])**2)
			result.append(-np.sum(np.abs(feature[i:i+step]-feature[j:j+step])))
			#result.append(-np.sum(np.abs(feature[i:i+step]-feature[j:j+step]))**2)
	result = np.array(result).flatten()
	#print result
	##print result
	return result+0.000001#/np.max(result)
	#return np.divide(result, np.sum(result))#*64

# extract feature, two types, A is the local features, B is the symmetric feature, in each of with the first dimension is the number of person while the second is the type of the pose
def ExtractFeature(images, feature_name, image_size, feature_block_size):
	person_num = len(images)
	features_A = [] #local feature
	features_B = [] #similarity of local feature

	for i in range(person_num):
		features_A.append([])
		features_B.append([])

	temp_feature_A = None
	if feature_name == 'LPQ':
		temp_feature_A = SpatialHistogram(lbp_operator=LPQ(), sz = (image_size[0]/feature_block_size[0], image_size[1]/feature_block_size[1]))
		for i in range(person_num):
			for j in range(len(images[i])):
				img_resized = cv2.resize(images[i][j], image_size)
				temp_A = temp_feature_A.extract(img_resized)
				#print temp_A.shape
				#print feature_A_extracted
				temp_B = ExtractFeatureBSelf(temp_A, feature_name)
		
				features_A[i].append(temp_A)
				features_B[i].append(temp_B)
				#features_B[i].append(CalPoseFeature(img_resized, image_size))
	if feature_name == 'SIFT':
		for i in range(person_num):
			for j in range(len(images[i])):
				img_resized_o = cv2.resize(images[i][j], image_size)
				img_resized = np.zeros((35,35), dtype=np.uint8)
				img_resized[2:-1, 2:-1] = img_resized_o
				sift = cv2.SIFT()
				kp = []
				#temp = cv2.KeyPoint(0,0,10)
				for k in range(2, 35, 5):
					for l in range(2, 35, 5):
						temp = cv2.KeyPoint(k, l, 5)
						kp.append(temp)

				kp, fe = sift.compute(img_resized, kp)
				#print fe.shape
				fe = np.reshape(np.array(fe), 7*7*128)
				feature_A_extracted = fe#ature_A_extracted1

				#print feature_A_extracted#.shape
				#print feature_A_extracted1#.shape
				#print feature_A_extracted2#.shape
				features_A[i].append(feature_A_extracted)
				feature_B_extracted = ExtractFeatureBSelf(feature_A_extracted, feature_name)
				#features_B[i].append(CalPoseFeature(img_resized, image_size))
				#feature_B_extracted = CalPoseFeature(img_resized, image_size)
				features_B[i].append(feature_B_extracted)


	#print '....!!!!!!.....', features_A[0][0], features_B[0][0]
	return features_A, features_B

#Form feature difference between same person but with different poses
def FormTrainingMatrices(pca_features_A, pca_features_B, training_pool):
	L = []
	P = []
	for i in range(86):
		training_pool_cp = training_pool[i][:]
		for j in training_pool[i]:
			training_pool_cp.remove(j)
			for k in training_pool_cp:
				L.append(pca_features_A[i][j]-pca_features_A[i][k])
				P.append(pca_features_B[i][j]-pca_features_B[i][k])
	L = np.array(L)
	P = np.array(P)
	print L.shape
	print P.shape
	#print L
	return L, P

def FormNegTrainingMatrices(pca_features_A, pca_features_B, training_pool):
	L_n = []
	P_n = []
	L_evg = []
	P_evg = []
	
	for i in range(86):
		L_evg.append(np.mean(np.array(pca_features_A[i][training_pool[i]]), axis=0))
		P_evg.append(np.mean(np.array(pca_features_B[i][training_pool[i]]), axis=0))

	for i in range(86):
		for j in range(86):
			if j > i:
				L_n.append(L_evg[i]- L_evg[j])
				P_n.append(P_evg[i]- P_evg[j])

	L_n = np.array(L_n)
	P_n = np.array(P_n)
	#print L_n.shape
	#print P_n.shape
	#print L_n
	return L_n, P_n


def ComputeDis(a,b):
	#return np.sum((a-b)**2)#/(LA.norm(a)*LA.norm(b))#normalized eucindean
	#return LA.norm(a/LA.norm(a)- b/LA.norm(b))
	return LA.norm(a/LA.norm(a)-b/LA.norm(b))#
	#return -np.sum(a*b)/LA.norm(a)/LA.norm(b)

def Recognition(features, training_pool):
	results_right = 0
	results_wrong = 0
	
	X = []
	y = []
	model = KNeighborsClassifier(n_neighbors=8, metric=ComputeDis)#'euclidean')#'pyfunc', func=ComputeDis)
	#pyfunc = DistanceMetric.get_metric("pyfunc", func=ComputeDis)
	#model = KNeighborsClassifier(n_neighbors=1, metric='pyfunc')
	#model = LinearDiscriminantAnalysis()
	#model = SVC()
	count = 0
	for k in range(86):
		for i in training_pool[k]:
			count += 1
			X.append(features[k][i])
			y.append(k)
	print 'training: ', count
	#print y
	model.fit(X, y)
	count = 0
	for k in range(86):
		#for j in testing_pool:
		for j in range(len(features[k])):
			if j not in training_pool[k]:
			#print len(features[k]
				count += 1
				if model.predict([features[k][j]]) == k:
					results_right += 1.0
				else:
					results_wrong += 1.0
	results = results_right / (results_right+results_wrong)
	print 'testing: ', count
	print results
	return results

def TrainingA(L, P, L_n, P_n, feature_dimention):
	#
	#A = np.zeros((feature_dimention, feature_dimention))+1.0/feature_dimention
	#A = A.flatten()
	#A, f, d = fmin_l_bfgs_b(ComputeCost, A, ComputeGra, (L, P, feature_dimention), disp=0)#, factr=1e10)
	#print f
	#print d
	#A = A.reshape((feature_dimention, feature_dimention))


	#both
	#A = np.zeros((feature_dimention, feature_dimention))+1.0/feature_dimention
	#A = A.flatten()
	#A, f, d = fmin_l_bfgs_b(ComputeCost, A, ComputeGra, (L, P, L_n, P_n, feature_dimention), disp=1)#, factr=1e10)
	#A = A.reshape((feature_dimention, feature_dimention))
	#print f
	#print d

	#
	#A = np.dot(np.dot(LA.pinv(np.dot(P.T, P)), P.T), L) #only positive
	#both positive and negative
	weight = 1e-4
	A = np.dot(LA.pinv(np.dot(P.T, P)-weight*np.dot(P_n.T, P_n)), np.dot(P.T, L)-weight*np.dot(P_n.T, L_n))
	#A  = np.dot(LA.pinv(np.dot(P.T, P)-np.dot(P_n.T, P_n)*0.0), (np.dot(P.T, L)-np.dot(P_n.T, L_n)*0.0))
	print weight
	return A

def ComputeLearnedFeature(pca_features_A, pca_features_B, A):
	learned_features = []
	for i in range(len(pca_features_A)):
		learned_features.append([])
	for i in range(len(pca_features_A)):
		for j in range(len(pca_features_A[i])):
			learned_features[i].append(pca_features_A[i][j]-np.dot(pca_features_B[i][j], A))
	return learned_features

if __name__ == "__main__":
	feature_dimention = 100
	images = ReadImages()
	features_A_b, features_B_b =ExtractFeature(images, 'LPQ', (32, 32), (4,4))
	accuracies = np.zeros(10)
	accuracies_o = np.zeros(10)
	random_traning = []

	random.seed(2207)
	for kk in range(10):
		random_traning.append([])
	for kk in range(10):
		for jj in range(86):
			sample_num_person = len(features_A_b[jj])
			random_traning[kk].append(random.sample(xrange(sample_num_person), 8))
	#print random_traning
	for j in range(10):
		features_A = np.copy(features_A_b)
		features_B = np.copy(features_B_b)
		#training_pool = range(8)#(bb[j][0:7]-1).tolist()
		#testing_pool = [8,9,10]#(bb[j][7:]-1).tolist()
		#print training_pool
		#print testing_pool
		PCA_A, PCA_B, pca_features_A, pca_features_B = PCATraining(features_A, features_B, random_traning[j], feature_dimention)
		L, P = FormTrainingMatrices(pca_features_A, pca_features_B, random_traning[j])
		L_n, P_n = FormNegTrainingMatrices(pca_features_A, pca_features_B, random_traning[j])
		A = TrainingA(L, P, L_n, P_n, feature_dimention)
		learned_features = ComputeLearnedFeature(pca_features_A, pca_features_B, A)
		print 'learned:'
		temp1 = Recognition(learned_features, random_traning[j])
		accuracies[j] = temp1
		print 'original:'
		temp2 = Recognition(pca_features_A, random_traning[j])
		accuracies_o[j] = temp2
	print 'learned:', np.mean(accuracies), np.std(accuracies)
	print 'original:', np.mean(accuracies_o), np.std(accuracies_o)