import os
import shutil
import cv2
import cv2.cv as cv
from facerec.feature import *
from facerec.lbp import *
import numpy as np
import pickle
import random
from sklearn import decomposition
from sklearn.neighbors import KNeighborsClassifier
from sklearn.svm import *
from numpy import linalg as LA
from scipy.optimize import *
from sklearn.metrics.pairwise import cosine_similarity
from skimage.feature import *
from sklearn.discriminant_analysis import LinearDiscriminantAnalysis
import warnings
warnings.filterwarnings("ignore", category=DeprecationWarning)

def NormalizedCorrelation(p, q):
	p = np.asarray(p).flatten()
	q = np.asarray(q).flatten()
	pmu = p.mean()
	qmu = q.mean()
	pm = p - pmu
	qm = q - qmu
	return (np.dot(pm, qm) / (np.sqrt(np.dot(pm, pm)) * np.sqrt(np.dot(qm, qm))))

def zscore(X, mean=None, std=None):
	X = np.asarray(X)
	if mean is None:
		mean = X.mean()
	if std is None:
		std = X.std()
	X = (X-mean)/std
	return X

#save variables using pickle package
def SaveVariable(variable, path):
	f = open(path, 'w')
	pickle.dump(variable, f)
	f.close

#load variables using pickle package
def ReadVariable(path):
	f = open(path)
	temp = pickle.load(f)
	f.close
	return temp

#PCA training, return the learned PCA model and transformed features
def PCATraining(features_A, features_B, training_pool, feature_dimention):
	training_features_A = []
	training_features_B = []
	pca_features_A = []
	pca_features_B = []
	y = []
	for i in training_pool:
		#print features_A[i]
		for j in range(len(features_A[i])):
			#print features_A[i][j]
			training_features_A.append(features_A[i][j])
			training_features_B.append(features_B[i][j])
			y.append(i)
	##print len(training_features_A)
	#print training_features_A

	pca_A = decomposition.PCA(feature_dimention)
	pca_A.fit(training_features_A)
	pca_B = decomposition.PCA(feature_dimention)
	pca_B.fit(training_features_B)
	"""

	#LDA
	pca_A = LinearDiscriminantAnalysis(n_components=feature_dimention)
	pca_A.fit(training_features_A, y)
	pca_B = LinearDiscriminantAnalysis(n_components=feature_dimention)
	pca_B.fit(training_features_B, y)
	"""
	for i in range(len(features_A)):
		pca_features_A.append(pca_A.transform(features_A[i]))
		pca_features_B.append(pca_B.transform(features_B[i]))
	return pca_A, pca_B, pca_features_A, pca_features_B


# return a list, where the first index is the person id, the second is the pose id
def ReadImages(index, paths, poses, person_num_array):
	images = [] #used to store the images, the first index is the person id, the second index is the pose id
	if index == 0: #for Multi-PIE, there are 337 persons
		for i in range (person_num_array[index]):
			images.append([])
		count = -1
		for i in range(1, 347):
			if i not in [213, 270, 275, 281, 282, 283, 307, 331, 340]:
				count += 1
				for pose in poses[index]:
					image_path = paths[index] + str(i).zfill(3) + '_01_01_' + pose + '_18.jpg'
					#print image_path
					img = cv2.imread(image_path, cv2.IMREAD_GRAYSCALE)
					images[count].append(img)
					#cv2.imshow('test', img)
					#cv2.waitKey(1)

	elif index == 1: # for Feret database, there are 200 persons
		for i in range (person_num_array[index]):
			images.append([])
		count = 0
		for i in range(1, 201):
			for pose in poses[index]:
				count += 1
				image_path = paths[index] + pose + '(' + str(i) + ').jpg'
				#print image_path
				img = cv2.imread(image_path, cv2.IMREAD_GRAYSCALE)
				images[i-1].append(img)
				#print images
				#cv2.imshow('test', img)
				#cv2.waitKey(1)
		print count

	elif index == 2: # for FEI database, there are 200 persons
		for i in range (person_num_array[index]):
			images.append([])
		count = 0
		for i in range(1, 201):
			for pose in poses[index]:
				count += 1
				image_path = paths[index] + str(i) + '-' + pose + '.jpg'
				#print image_path
				img = cv2.imread(image_path, cv2.IMREAD_GRAYSCALE)
				images[i-1].append(img)
				#images[i-1].append(img[10:-10,10:-10])
				#cv2.imshow('test', img)
				#cv2.waitKey(1)

	return images

def ExtractFeatureBSelf(feature, feature_name):
	#print np.sum(feature)
	result = []
	step = 0
	if feature_name == 'LBP':
		step = 53
	elif feature_name == 'HOG':
		step = 9
	elif feature_name == 'LPQ':
		step = 256
	elif feature_name == 'SIFT':
		step = 128
	for i in range(0, len(feature), step):
		#print np.sum(feature[i:i+step])
		for j in range(i+step, len(feature), step):
			##print feature[i:i+64]
			##print feature[j:j+64]
			#result.append(np.sum((np.minimum(feature[i:i+step], feature[j:j+step]))))
			#result.append((NormalizedCorrelation(feature[i:i+step],feature[j:j+step])+1.0)/2.0)
			#result.append(cosine_similarity(feature[i:i+step],feature[j:j+step]))

			#print (-LA.norm(feature[i:i+step]-feature[j:j+step])**2)
			#result.append(np.exp(-LA.norm(feature[i:i+step]-feature[j:j+step])))
			#result.append(-np.sum(np.abs(feature[i:i+step]-feature[j:j+step])))

			#used
			#result.append(-LA.norm(feature[i:i+step]-feature[j:j+step]))
			#result.append(-LA.norm(feature[i:i+step]-feature[j:j+step])**2)
			#result.append(-np.sum(np.abs(feature[i:i+step]-feature[j:j+step])))
			result.append(-np.sum(np.abs(feature[i:i+step]-feature[j:j+step]))**2)
	result = np.array(result).flatten()
	#print result
	##print result
	return result#/np.max(result)
	#return np.divide(result, np.sum(result))#*64
def CalPoseFeature(src1, image_size, step=10):
	height_used = image_size[0]
	width_used = image_size[1]
	src = np.copy(src1)
	if np.mod(height_used, step):
		mul = int(height_used)/int(step)+1
		src = cv2.resize(src, (mul*step, mul*step))
	hist_cell = []
	for i in range(0, height_used, 10):
		#print i
		for j in range(0, width_used, 10):
			#print j
			hist= cv2.calcHist([src[i:i+step, j:j+step]], [0], None, [256], [0.0,255.0])
			hist = np.divide(hist, step*step)
			hist_cell.append(hist)
			#print np.sum(hist)
	feature = []
	for i in range(0, len(hist_cell)):
		for j in range(i+1, len(hist_cell)):
			feature.append(cv2.compareHist(hist_cell[i], hist_cell[j], cv.CV_COMP_INTERSECT))
	#return np.multiply(np.divide(feature, np.sum(feature)), 64)
	return np.divide(feature, np.sum(feature))#*100
	#p = np.asarray(feature).flatten()
	#return p/np.sqrt(np.dot(p, p))

# extract feature, two types, A is the local features, B is the symmetric feature, in each of with the first dimension is the number of person while the second is the type of the pose
def ExtractFeature(images, feature_name, image_size, feature_block_size):
	person_num = len(images)
	features_A = [] #local feature
	features_B = [] #similarity of local feature

	for i in range(person_num):
		features_A.append([])
		features_B.append([])

	temp_feature_A = None
	if feature_name == 'LPQ':
		temp_feature_A = SpatialHistogram(lbp_operator=LPQ(), sz = (image_size[0]/feature_block_size[0], image_size[1]/feature_block_size[1]))
	if feature_name == 'LBP':
		temp_feature_A = SpatialHistogram(lbp_operator=ExtendedLBP(), sz = (image_size[0]/feature_block_size[0], image_size[1]/feature_block_size[1]))
	if feature_name != 'SIFT' and feature_name != 'HOG':
		for i in range(person_num):
			for j in range(len(images[i])):
				"""
				img_resized = cv2.resize(images[i][j], image_size)
				feature_A_extracted1 = temp_feature_A.extract(img_resized)
				fliped_image = cv2.flip(img_resized, 1)
				feature_A_extracted2 = temp_feature_A.extract(fliped_image)
				feature_A_extracted = np.concatenate((feature_A_extracted1, feature_A_extracted2))
				#print feature_A_extracted.shape
				#print feature_A_extracted1.shape
				#print feature_A_extracted2.shape
				#print feature_A.shape
				feature_B_extracted = ExtractFeatureBSelf(feature_A_extracted, feature_name)
				features_A[i].append(feature_A_extracted)
				features_B[i].append(feature_B_extracted)
				#print feature_B.shape
				#cv2.imshow('test', img_resized)
				#cv2.waitKey(1)
				"""
				img_resized = cv2.resize(images[i][j], image_size)
				feature_A_extracted = None
				feature_B_extracted = None
				#pixels_per_cell_array = [(10,10),(5,5),(20,20)]
				pixels_per_cell_array = [(10,10)]#,(5,5)]#, (8,8)]
				for ii in range(len(pixels_per_cell_array)):
					#temp_feature_A = SpatialHistogram(lbp_operator=LPQ(), sz = pixels_per_cell_array[ii])
					temp_A = temp_feature_A.extract(img_resized)
					#print temp_A.shape
					#print feature_A_extracted
					temp_B = ExtractFeatureBSelf(temp_A, feature_name)
					if ii == 0:
						feature_A_extracted = temp_A
						feature_B_extracted = temp_B
					else:
						feature_A_extracted = np.concatenate((feature_A_extracted, temp_A))
						feature_B_extracted = np.concatenate((feature_B_extracted, temp_B))
					#print feature_A_extracted.shape
				features_A[i].append(feature_A_extracted)
				features_B[i].append(feature_B_extracted)
				#features_B[i].append(CalPoseFeature(img_resized, image_size))

	if feature_name == 'HOG':
		for i in range(person_num):
			for j in range(len(images[i])):
				img_resized = cv2.resize(images[i][j], image_size)
				feature_A_extracted = None
				feature_B_extracted = None
				pixels_per_cell_array = [(10,10),(5,5),(20,20)]
				for ii in range(1):
					temp_A = hog(img_resized, pixels_per_cell=pixels_per_cell_array[ii], cells_per_block=(1, 1))
					#print feature_A_extracted.shape
					#print feature_A_extracted
					temp_B = ExtractFeatureBSelf(temp_A, feature_name)
					if ii == 0:
						feature_A_extracted = temp_A
						feature_B_extracted = temp_B
					else:
						feature_A_extracted = np.concatenate((feature_A_extracted, temp_A))
						feature_B_extracted = np.concatenate((feature_B_extracted, temp_B))
					#print feature_A_extracted.shape
				features_A[i].append(feature_A_extracted)
				features_B[i].append(feature_B_extracted)

	if feature_name == 'SIFT':
		for i in range(person_num):
			for j in range(len(images[i])):
				img_resized = cv2.resize(images[i][j], image_size)
				sift = cv2.SIFT()
				kp = []
				#temp = cv2.KeyPoint(0,0,10)
				for k in range(2, image_size[1], 5):
					for l in range(2, image_size[0], 5):
						temp = cv2.KeyPoint(k, l, 5)
						kp.append(temp)

				kp, fe = sift.compute(img_resized, kp)
				#print fe.shape
				fe = np.reshape(np.array(fe), 20*20*128)
				feature_A_extracted1 = np.copy(zscore(fe
				)) #fe/np.sum(fe)

				"""
				fliped_image = cv2.flip(img_resized, 1)
				kp, fe = sift.compute(fliped_image, kp)
				#print fe.shape
				fe = np.reshape(np.array(fe), 11*11*128)
				feature_A_extracted2 = np.copy(zscore(fe
				))
				feature_A_extracted = np.concatenate((feature_A_extracted1, feature_A_extracted2))
				"""

				feature_A_extracted = fe#ature_A_extracted1

				#print feature_A_extracted#.shape
				#print feature_A_extracted1#.shape
				#print feature_A_extracted2#.shape
				features_A[i].append(feature_A_extracted)
				feature_B_extracted = ExtractFeatureBSelf(feature_A_extracted, feature_name)
				#features_B[i].append(CalPoseFeature(img_resized, image_size))
				#feature_B_extracted = CalPoseFeature(img_resized, image_size)
				features_B[i].append(feature_B_extracted)



	return features_A, features_B

#Form feature difference between same person but with different poses
def FormTrainingMatrices(pca_features_A, pca_features_B, training_pool):
	L = []
	P = []
	for i in training_pool:
		num_per_person = len(pca_features_A[i])
		for j in range(num_per_person):
			for k in range(j+1, num_per_person):
				L.append(pca_features_A[i][j]-pca_features_A[i][k])
				P.append(pca_features_B[i][j]-pca_features_B[i][k])
	L = np.array(L)
	P = np.array(P)
	print L.shape
	print P.shape
	return L, P

#Form feature difference between different persons but with the same pose
def FormNegTrainingMatrices1(pca_features_A, pca_features_B, training_pool):
	L_n = []
	P_n = []
	num_per_person = len(pca_features_A[0])
	for j in range(num_per_person):
		for i in training_pool:
			for k in training_pool:
				if k > i:
					L_n.append(pca_features_A[i][j]-pca_features_A[k][j])
					P_n.append(pca_features_B[i][j]-pca_features_B[k][j])
	L_n = np.array(L_n)
	P_n = np.array(P_n)
	print L_n.shape
	print P_n.shape
	return L_n, P_n

def FormNegTrainingMatrices(pca_features_A, pca_features_B, training_pool):
	L_n = []
	P_n = []
	L_evg = []
	P_evg = []
	num_per_person = len(pca_features_A[0])
	for i in training_pool:
		L_evg.append(np.mean(np.array(pca_features_A[i]), axis=0))
		P_evg.append(np.mean(np.array(pca_features_B[i]), axis=0))

	for i in range(len(L_evg)):
		for j in range(len(L_evg)):
			if j > i:
				L_n.append(L_evg[i]- L_evg[j])
				P_n.append(P_evg[i]- P_evg[j])

	L_n = np.array(L_n)
	P_n = np.array(P_n)
	print L_n.shape
	print P_n.shape
	return L_n, P_n

def ComputeCost(A, L, P, L_n, P_n, feature_dimention):
	A = A.reshape((feature_dimention, feature_dimention))
	#print LA.norm(L-np.dot(P, A))**2 + LA.norm(A)**2
	c = LA.norm(L-np.dot(P, A))**2# + LA.norm(A)**2
	#c -= (LA.norm(L_n-np.dot(P_n, A))**2)/10.0
	#temp = L-np.dot(P, A)
	#c = np.trace(np.dot(temp, temp.T))
	temp_d = np.dot(P_n, A)
	#d = np.trace(np.dot(temp_d, temp_d.T))
	d = (LA.norm(temp_d)**2)/100.0
	return c#+d

def ComputeGra(A, L, P, L_n, P_n, feature_dimention):
	A = A.reshape((feature_dimention, feature_dimention))
	#print (-2*np.dot((L-np.dot(P, A)).T, P)+2*A).shape
	g = -2*np.dot(P.T, L-np.dot(P, A))#-2*A
	#g += 2*np.dot(P_n.T, L_n-np.dot(P_n, A))/10.0
	g_d = 2*np.dot(np.dot(P_n.T, P_n),A)/100.0
	#g= g+g_d
	return g.flatten()

def ComputeDis(a,b):
	#return np.sum((a-b)**2)/(LA.norm(a)*LA.norm(b))#normalized eucindean
	#return LA.norm(a/LA.norm(a)- b/LA.norm(b))
	return LA.norm(a/LA.norm(a)-b/LA.norm(b))#
	#return -np.sum(a*b)/LA.norm(a)/LA.norm(b)

def Recognition(features, testing_pool):
	num_per_person = len(features[0])
	results_right = np.zeros((num_per_person, num_per_person))
	results_wrong = np.zeros((num_per_person, num_per_person))
	for i in range(num_per_person):
		X = []
		y = []
		#model = KNeighborsClassifier(n_neighbors=1, metric='euclidean')#metric='pyfunc', func=ComputeDis)
		model = KNeighborsClassifier(n_neighbors=1, metric=ComputeDis)
		#model = LinearDiscriminantAnalysis()
		#model = SVC()
		for k in testing_pool:
			X.append(features[k][i])
			y.append(k)
		model.fit(X, y)
		for k in testing_pool:
			for j in range(num_per_person):
				if j != i:
					if model.predict([features[k][j]]) == k:
						results_right[i][j] += 1.0
					else:
						results_wrong[i][j] += 1.0
	results = results_right / (results_right+results_wrong+np.eye(num_per_person))
	#results = np.nan_to_num(results)
	print results
	print 'mean: ', np.sum(results, axis=1) / (num_per_person-1)
	return results, np.sum(results, axis=1) / (num_per_person-1)

def TrainingA(L, P, L_n, P_n, feature_dimention):
	#
	#A = np.zeros((feature_dimention, feature_dimention))+1.0/feature_dimention
	#A = A.flatten()
	#A, f, d = fmin_l_bfgs_b(ComputeCost, A, ComputeGra, (L, P, feature_dimention), disp=0)#, factr=1e10)
	#print f
	#print d
	#A = A.reshape((feature_dimention, feature_dimention))


	#both
	#A = np.zeros((feature_dimention, feature_dimention))+1.0/feature_dimention
	#A = A.flatten()
	#A, f, d = fmin_l_bfgs_b(ComputeCost, A, ComputeGra, (L, P, L_n, P_n, feature_dimention), disp=1)#, factr=1e10)
	#A = A.reshape((feature_dimention, feature_dimention))
	#print f
	#print d

	#
	#A = np.dot(np.dot(LA.pinv(np.dot(P.T, P)), P.T), L) #only positive
	#both positive and negative
	weight = 10e-5
	A = np.dot(LA.pinv(np.dot(P.T, P)-weight*np.dot(P_n.T, P_n)), np.dot(P.T, L)-weight*np.dot(P_n.T, L_n))
	#A  = np.dot(LA.pinv(np.dot(P.T, P)-np.dot(P_n.T, P_n)*0.0), (np.dot(P.T, L)-np.dot(P_n.T, L_n)*0.0))
	print A
	return A

def ComputeLearnedFeature(pca_features_A, pca_features_B, A):
	learned_features = []
	for i in range(len(pca_features_A)):
		learned_features.append([])
	for i in range(len(pca_features_A)):
		for j in range(len(pca_features_A[i])):
			learned_features[i].append(pca_features_A[i][j]-np.dot(pca_features_B[i][j], A))
	return learned_features

if __name__ == "__main__":
	paths = ['/home/xd/Documents/PhD/Database/MultiPIE/', '/home/xd/Documents/PhD/Database/Feret/','/home/xd/Documents/PhD/Database/FEI/']
	#poses = [['110', '120', '090', '081', '080', '130', '140', '051', '050', '041', '190', '191', '200', '010', '240'], ['bi', 'bh', 'bg', 'bf', 'ba', 'be', 'bd', 'bc', 'bb'], ['03', '04', '05', '11', '06', '07', '08']]
	poses = [['080', '130', '140', '051', '050', '041', '190'], ['bi', 'bh', 'bg', 'bf', 'ba', 'be', 'bd', 'bc', 'bb'], ['03', '04', '05', '11', '06', '07', '08']]
	person_num_array = [337, 200, 200]
	image_size = (100, 100) #image size used to extract local feature
	feature_block_size = (10,10) #block size used to extract local feature
	person_num_training = 100 # person number used for training
	feature_dimention = 500
	for i in [1]:#range(3): # three databases
		cross_num = 1
		num_per_person = len(poses[i])
		results = np.zeros((num_per_person,num_per_person))
		average_results = np.sum(results, axis=1)
		results_o = np.zeros((num_per_person,num_per_person))
		average_results_o = np.sum(results_o, axis=1)
		random.seed(2207)
		full_pool = range(person_num_array[i])
		training_pool = None
		testing_pool = None
		print person_num_array[i]
		images = ReadImages(i, paths, poses, person_num_array)
		features_A, features_B =ExtractFeature(images, 'SIFT', image_size, feature_block_size)
		for j in range(cross_num):
			#training_pool = sorted(random.sample(full_pool,  person_num_training))
			training_pool = range(100)
			testing_pool = [x for x in full_pool if x not in training_pool]
			#testing_pool = range(100)
			#training_pool = [x for x in full_pool if x not in testing_pool]
			training_pool.sort()
			testing_pool.sort()
			#testing_pool = range(100, 200)
			#print (training_pool), (testing_pool)
			#print (sorted(training_pool + testing_pool))
			print training_pool
			print testing_pool
			#SaveVariable(features_A, './features_A')
			#SaveVariable(features_B, './features_B')
			#features_A = ReadVariable('./features_A')
			#print features_A
			#features_B = ReadVariable('./features_B')
			PCA_A, PCA_B, pca_features_A, pca_features_B = PCATraining(features_A, features_B, training_pool, feature_dimention)
			#SaveVariable(pca_features_A, './pca_features_A')
			#SaveVariable(pca_features_B, './pca_features_B')
			#pca_features_A = ReadVariable('./pca_features_A')
			#print features_A
			#pca_features_B = ReadVariable('./pca_features_B')
			L, P = FormTrainingMatrices(pca_features_A, pca_features_B, training_pool)
			L_n, P_n = FormNegTrainingMatrices(pca_features_A, pca_features_B, training_pool)

			print 'Training Data formed'
			A = TrainingA(L, P, L_n, P_n, feature_dimention)
			learned_features = ComputeLearnedFeature(pca_features_A, pca_features_B, A)
			temp1, temp2 = Recognition(learned_features, testing_pool)
			results += temp1
			average_results += temp2
			#print A
			temp1, temp2 = Recognition(pca_features_A, testing_pool)
			results_o += temp1
			average_results_o += temp2
			#print L
			#print P
		print
		print 'learned:'
		print results/cross_num
		print average_results/cross_num
		print 'PCA:'
		print results_o/cross_num
		print average_results_o/cross_num
